/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item;

import com.lycanitesmobs.ExtendedPlayer;
import com.lycanitesmobs.core.entity.EntityCreatureRideable;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.info.MobInfo;
import com.lycanitesmobs.core.item.ItemBase;
import com.lycanitesmobs.core.pets.PetEntry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class ItemSoulstone
extends ItemBase {
    public ItemSoulstone() {
        this.itemName = "soulstone";
        this.setup();
    }

    @Override
    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    @Override
    public boolean onItemRightClickOnEntity(EntityPlayer player, Entity entity, ItemStack itemStack) {
        ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer(player);
        if (playerExt == null) {
            return false;
        }
        if (!(entity instanceof EntityCreatureTameable)) {
            if (!player.func_130014_f_().field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"message.soulstone.invalid")));
            }
            return false;
        }
        EntityCreatureTameable entityTameable = (EntityCreatureTameable)entity;
        MobInfo mobInfo = entityTameable.mobInfo;
        if (!mobInfo.isTameable() || entityTameable.func_70902_q() != player) {
            if (!player.func_130014_f_().field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"message.soulstone.untamed")));
            }
            return false;
        }
        if (entityTameable.getPetEntry() != null) {
            if (!player.func_130014_f_().field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"message.soulstone.exists")));
            }
            return false;
        }
        if (!player.func_130014_f_().field_72995_K) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemStack.func_190920_e(Math.max(0, itemStack.func_190916_E() - 1));
            }
            if (itemStack.func_190916_E() <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
            }
        }
        if (player.func_130014_f_().field_72995_K) {
            for (int i = 0; i < 32; ++i) {
                entity.func_130014_f_().func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, entity.field_70165_t + (double)(4.0f * player.func_70681_au().nextFloat()) - 2.0, entity.field_70163_u + (double)(4.0f * player.func_70681_au().nextFloat()) - 2.0, entity.field_70161_v + (double)(4.0f * player.func_70681_au().nextFloat()) - 2.0, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (!player.func_130014_f_().field_72995_K) {
            String petType = "pet";
            if (entity instanceof EntityCreatureRideable) {
                petType = "mount";
            }
            String message = I18n.func_74838_a((String)("message.soulstone." + petType + ".added"));
            message = message.replace("%creature%", mobInfo.getTitle());
            player.func_145747_a((ITextComponent)new TextComponentString(message));
            PetEntry petEntry = PetEntry.createFromEntity(player, entityTameable, petType);
            playerExt.petManager.addEntry(petEntry);
            playerExt.sendPetEntriesToPlayer(petType);
            petEntry.assignEntity(entity);
            entityTameable.setPetEntry(petEntry);
        }
        return true;
    }
}

